% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-PathwayConstructor.R
\name{PathwayConstructor}
\alias{PathwayConstructor}
\title{PathwayConstructor}
\description{
PathwayConstructor R6 object.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PathwayConstructor-new}{\code{PathwayConstructor$new()}}
\item \href{#method-PathwayConstructor-validate}{\code{PathwayConstructor$validate()}}
\item \href{#method-PathwayConstructor-construct}{\code{PathwayConstructor$construct()}}
\item \href{#method-PathwayConstructor-getAndromeda}{\code{PathwayConstructor$getAndromeda()}}
\item \href{#method-PathwayConstructor-editSettings}{\code{PathwayConstructor$editSettings()}}
\item \href{#method-PathwayConstructor-getSettings}{\code{PathwayConstructor$getSettings()}}
\item \href{#method-PathwayConstructor-clone}{\code{PathwayConstructor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-new"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-new}{}}}
\subsection{Method \code{new()}}{
Initialize method called by \code{PathwayConstructor$new()}.
\cr\cr
Choose the way you interface with the CDM, either through \code{DatabaseConnector} or \code{CDMConnector}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$new(cohorts, cohortTableName, cdmInterface)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cohorts}}{(\code{data.frame()})\cr
Data frame containing the following columns and data types:
\describe{
\item{cohortId \code{numeric(1)}}{Cohort ID's of the cohorts to be used in the cohort table.}
\item{cohortName \code{character(1)}}{Cohort names of the cohorts to be used in the cohort table.}
\item{type \code{character(1)} ["target", "event', "exit"]}{Cohort type, describing if the cohort is a target, event, or exit cohort}
}}

\item{\code{cohortTableName}}{(\code{character(1)})\cr
Cohort table name.}

\item{\code{cdmInterface}}{(\code{TreatmentPatterns::cdmInterface})\cr
A cdmInterface object created internally}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{invisible(self)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-validate"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-validate}{}}}
\subsection{Method \code{validate()}}{
Validation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{invisible(self)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-construct"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-construct}{}}}
\subsection{Method \code{construct()}}{
Construct the pathways. Generates \code{Andromeda::andromeda()} objects,
which can be fetched using \code{self$getAndromeda()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$construct(minEraDuration)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minEraDuration}}{(\code{integer(1)}: \code{0})\cr
Minimum time an event era should last to be included in analysis}

\item{\code{minEraDuration}}{(\code{integer(1)}: \code{0})\cr
Minimum time an event era should last to be included in analysis}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-getAndromeda"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-getAndromeda}{}}}
\subsection{Method \code{getAndromeda()}}{
Gets the \code{Andromeda::andromeda()} objects in a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$getAndromeda()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{list()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-editSettings"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-editSettings}{}}}
\subsection{Method \code{editSettings()}}{
Edit settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$editSettings(
  includeTreatments = "startDate",
  periodPriorToIndex = 0,
  minEraDuration = 0,
  splitEventCohorts = "",
  splitTime = 30,
  eraCollapseSize = 30,
  combinationWindow = 30,
  minPostCombinationDuration = 30,
  filterTreatments = "First",
  maxPathLength = 5,
  addNoPaths = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{includeTreatments}}{(\code{character(1)}: \code{"startDate"})\cr}

\item{\code{periodPriorToIndex}}{(\code{integer(1)}: \code{0})\cr
Number of days prior to the index date of the target cohort | that event
cohorts are allowed to start}

\item{\code{minEraDuration}}{(\code{integer(1)}: \code{0})\cr
Minimum time an event era should last to be included in analysis}

\item{\code{minEraDuration}}{(\code{integer(1)}: \code{0})\cr
Minimum time an event era should last to be included in analysis}

\item{\code{splitEventCohorts}}{(\code{character(n)}: \code{""})\cr
Specify event cohort to split in acute (< X days) and therapy (>= X days)}

\item{\code{splitTime}}{(\code{integer(1)}: \code{30})\cr
Specify number of days (X) at which each of the split event cohorts should
be split in acute and therapy}

\item{\code{eraCollapseSize}}{(\code{integer(1)}: \code{30})\cr
Window of time between which two eras of the same event cohort are collapsed
into one era}

\item{\code{combinationWindow}}{(\code{integer(1)}: \code{30})\cr
Window of time two event cohorts need to overlap to be considered a
combination treatment}

\item{\code{minPostCombinationDuration}}{(\code{integer(1)}: \code{30})\cr
Minimum time an event era before or after a generated combination treatment
should last to be included in analysis}

\item{\code{filterTreatments}}{(\code{character(1)}: \code{"First"} ["first", "Changes", "all"])\cr
Select first occurrence of (‘First’); changes between (‘Changes’); or all
event cohorts (‘All’).}

\item{\code{maxPathLength}}{(\code{integer(1)}: \code{5})\cr
Maximum number of steps included in treatment pathway}

\item{\code{addNoPaths}}{(\code{logical(1)}: \code{TRUE})\cr
Select to include untreated persons without treatment pathway in the
sunburst plot}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{data.frame()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-getSettings"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-getSettings}{}}}
\subsection{Method \code{getSettings()}}{
Getter method to get the specified settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$getSettings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{data.frame()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PathwayConstructor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PathwayConstructor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PathwayConstructor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
