## ------------------------------------------------------------------------
library(TransPhylo)
set.seed(0)

## ------------------------------------------------------------------------
neg=100/365
off.r=5
w.shape=10
w.scale=0.1
pi=0.25

## ------------------------------------------------------------------------
simu <- simulateOutbreak(neg=neg,pi=pi,off.r=off.r,w.shape=w.shape,
                         w.scale=w.scale,dateStartOutbreak=2005,dateT=2008)

## ------------------------------------------------------------------------
plot(simu)

## ------------------------------------------------------------------------
ttree<-extractTTree(simu)
plot(ttree)

## ------------------------------------------------------------------------
plot(ttree,type='detailed',w.shape,w.scale)

## ------------------------------------------------------------------------
ptree<-extractPTree(simu)
plot(ptree)

## ------------------------------------------------------------------------
library(ape)
p<-phyloFromPTree(ptree)
plot(p)
axisPhylo()

## ----eval=F--------------------------------------------------------------
#  write.tree(p,'tree.nwk')

## ------------------------------------------------------------------------
write.tree(p,'')

## ------------------------------------------------------------------------
dateLastSample(simu)

