% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top5.R
\name{top5}
\alias{top5}
\title{Top 5 most or least lucky numbers for EuroMillions/EuroJackpot}
\usage{
top5(eurolottery_results, date_since, least_lucky = FALSE)
}
\arguments{
\item{eurolottery_results}{The full list of EuroMillions/EuroJackpot results}

\item{date_since}{The date after which the analysis is to be performed, i.e. 2022-12-22}

\item{least_lucky}{If TRUE, the least lucky numbers will be returned (default FALSE)}
}
\value{
Top 5 numbers
}
\description{
Returns the top 5 most or least lucky euromillion numbers
}
\examples{
euromillions_results = EuroMillionsResults()
top_5 = top5(euromillions_results, '2022-12-22', least_lucky=TRUE)

}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
