% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_data.R, R/table_bindings.R
\name{add_treat_grps}
\alias{add_treat_grps}
\alias{add_total_group}
\alias{treat_grps}
\title{Combine existing treatment groups for summary}
\usage{
add_treat_grps(table, ...)

add_total_group(table, group_name = "Total")

treat_grps(table)
}
\arguments{
\item{table}{A \code{tplyr_table} object}

\item{...}{A named vector where names will become the new treatment group names,
and values will be used to construct those treatment groups}

\item{group_name}{The treatment group name used for the constructed 'Total' group}
}
\value{
The modified table object
}
\description{
Summary tables often present individual treatment groups,
but may additionally have a "Treatment vs. Placebo" or "Total" group added
to show grouped summary statistics or counts. This set of functions offers
an interface to add these groups at a table level and be consumed by
subsequent layers.
}
\details{
\code{add_treat_grps} allows you to specify specific groupings. This is done
by supplying named arguments, where the name becomes the new treatment group's
name, and those treatment groups are made up of the argument's values.

\code{add_total_group} is a simple wrapper around \code{add_treat_grps}. Instead of
producing custom groupings, it produces a "Total" group by the supplied name, which
defaults to "Total". This "Total" group is made up of all existing treatment
groups within the population dataset.

The function \code{treat_grps} allows you to see the custom treatment groups available
in your \code{tplyr_table} object
}
\examples{
tab <- tplyr_table(iris, Species)

# A custom group
add_treat_grps(tab, "Not Setosa" = c("versicolor", "virginica"))

# Add a total group
add_total_group(tab)

treat_grps(tab)
# Returns:
# $`Not Setosa`
#[1] "versicolor" "virginica"
#
#$Total
#[1] "setosa"     "versicolor" "virginica"
}
