% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_averaging_fits.R
\name{ma_dichotomous_fit}
\alias{ma_dichotomous_fit}
\title{ma_dichotomous_fit - Fit a model averaged dichotomous BMD model.}
\usage{
ma_dichotomous_fit(
  D,
  Y,
  N,
  model_list = integer(0),
  fit_type = "laplace",
  BMD_TYPE = "extra",
  BMR = 0.1,
  point_p = 0.01,
  alpha = 0.05,
  samples = 21000,
  burnin = 1000
)
}
\arguments{
\item{D}{doses matrix}

\item{Y}{response matrix}

\item{N}{number of replicates matrix}

\item{model_list}{a list of configurations for the single models (priors, model type)}

\item{fit_type}{the method used to fit (laplace, mle, or mcmc)}

\item{BMD_TYPE}{BMD_TYPE specifies the type of benchmark dose analysis to be performed. For continuous models, there are four types of BMD definitions that are commonly used. \cr
-    Standard deviation is the default option, but it can be explicitly specified with 'BMR_TYPE = "sd"' This definition defines the BMD as the dose associated with the mean/median changing a specified number of standard deviations from the mean at the control dose., i.e., it is the dose, BMD, that solves \eqn{\mid f(dose)-f(0) \mid = BMR \times \sigma} \cr
-    Relative deviation can be specified with 'BMR_TYPE = "rel"'. This defines the BMD as the dose that changes the control mean/median a certain percentage from the background dose, i.e. it is the dose, BMD that solves \eqn{\mid f(dose) - f(0) \mid = (1 \pm BMR) f(0)} \cr
-    Hybrid deviation can be specified with 'BMR_TYPE = "hybrid"'.  This defines the BMD that changes the probability of an adverse event by a stated amount relitive to no exposure (i.e 0).  That is, it is the dose, BMD, that solves \eqn{\frac{Pr(X > x| dose) - Pr(X >x|0)}{Pr(X < x|0)} = BMR}. For this definition, \eqn{Pr(X < x|0) = 1 - Pr(X > X|0) = \pi_0}, where \eqn{0 \leq \pi_0 < 1} is defined by the user as "point_p," and it defaults to 0.01.  Note: this discussion assumed increasing data.  The fitter determines the direction of the data and inverts the probability statements for decreasing data. \cr
-    Absolute deviation can be specified with 'BMR_TYPE="abs"'. This defines the BMD as an absolute change from the control dose of zero by a specified amount. That is the BMD is the dose that solves the equation \eqn{\mid f(dose) - f(0) \mid = BMR}}

\item{BMR}{This option specifies the benchmark response BMR. The BMR is defined in relation to the BMD calculation requested (see BMD).  By default, the "BMR = 0.1."}

\item{point_p}{This option is only used for hybrid BMD calculations. It defines a probability that is the cutpoint for observations.  It is the probability that observations have this probability, or less, of being observed at the background dose.}

\item{alpha}{Alpha is the specified nominal coverage rate for computation of the lower bound on the BMDL and BMDU, i.e., one computes a \eqn{100\times(1-\alpha)\% }.  For the interval (BMDL,BMDU) this is a \eqn{100\times(1-2\alpha)\% }.  By default, it is set to 0.05.}

\item{samples}{the number of samples to take (MCMC only)}

\item{burnin}{the number of burnin samples to take (MCMC only)}
}
\value{
a model object containing a list of single models
\itemize{
 \item \code{Individual_Model_X}: Here \code{X} is a number \eqn{1\leq X \leq n,} where \eqn{n}
        is the number of models in the model average.  For each \code{X}, this is an individual model
        fit identical to what is returned in `\code{single_continuous_fit}.'
 \item \code{ma_bmd}: The CDF of the model averaged BMD distribution. 
 \item \code{posterior_probs}: The posterior model probabilities used in the MA. 
 \item \code{bmd}: The BMD and the \eqn{100\times(1-2\alpha)\%} confidence intervals. 
}
}
\description{
Fit a model averaged dichotomous BMD model.
}
\examples{
\dontrun{
mData <- matrix(c(0, 2,50,
                  1, 2,50,
                  3, 10, 50,
                  16, 18,50,
                  32, 18,50,
                  33, 17,50),nrow=6,ncol=3,byrow=TRUE)
D <- mData[,1]
Y <- mData[,2]
N <- mData[,3]
model = ma_dichotomous_fit(D,Y,N)

summary(model)
}
}
