% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_filter.R
\name{check_filter}
\alias{check_filter}
\title{Check and filter invalid base of nucleotide sequences}
\usage{
check_filter(ntseq, method)
}
\arguments{
\item{ntseq}{Sequence (5' to 3') of one strand of the DNA nucleic acid duplex
as string or vector of characters}

\item{method}{TM_Wallace: check and return "A","B","C","D","G","H","I","K","M","N","R","S","T","V","W" and "Y"

TM_GC: check and return "A","B","C","D","G","H","I","K","M","N","R","S","T","V","W", "X" and "Y"

TM_NN: check and return "A","C","G","I" and "T"}
}
\value{
Return a sequence which fullfils the requirements of the given method.
}
\description{
In general, whitespaces and non-base characters are removed and characters are converted to uppercase in given method.
}
\examples{

ntseq <- c("ATCGBDHKMNRVYWSqq")
check_filter(ntseq,method='Tm_Wallace')
check_filter(ntseq,method='Tm_NN')

}
\references{
\code{citation("TmCalculator")}
}
\author{
Junhui Li
}
