% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covres.R
\name{covres}
\alias{covres}
\title{Sample Covariance Matrix of Residuals}
\usage{
covres(data, Omega.list, k = 1)
}
\arguments{
\item{data}{tensor object stored in a m1 * m2 * ... * mK * n array, where n is sample size
and mk is dimension of the kth tensor mode.}

\item{Omega.list}{list of precision matrices of tensor, i.e., \code{Omega.list[[k]]} is precision matrix 
for the kth tensor mode, \eqn{k \in \{1 , \ldots, K\}}{ 1 <= k <= K }.}

\item{k}{index of interested mode, default is 1.}
}
\value{
A matrix whose (i,j) entry (includes diagnoal) is sample covariance of the ith and jth residuals in the kth mode. See \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)} for details.
}
\description{
Generate sample covariance matrix of residuals (includes diagnoal) described in \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)}.
}
\details{
This function computes sample covariance of residuals and is the basis for support recovery procedure in \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)}. Note that output matrix includes 
diagnoal while bias corrected matrix (output of \code{\link{biascor}}) for inference is off-diagnoal, see \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)} for details.
 Elements in Omega.list are true precision matrices or estimation of the true ones, the latter can be output of \code{\link{Tlasso.fit}}.
}
\examples{

m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 
k=1 # index of interested mode
lambda.thm = 20*c( sqrt(log(m.vec[1])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[2])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[3])/(n*prod(m.vec))))
DATA=Trnorm(n,m.vec,type='Chain') 
# obersavations from tensor normal distribution
out.tlasso = Tlasso.fit(DATA,T=1,lambda.vec = lambda.thm)   
# output is a list of estimation of precision matrices
rho=covres(DATA, out.tlasso, k = k) # sample covariance of residuals, including diagnoal 
rho

}
\author{
Will Wei Sun, Zhaoran Wang, Xiang Lyu, Han Liu, Guang Cheng.
}
\seealso{
\code{\link{varcor}}, \code{\link{biascor}}
}

