% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TippingPoint.R
\name{TippingPoint.default}
\alias{TippingPoint.default}
\title{Default method for TippingPoint}
\usage{
\method{TippingPoint}{default}(outcome, treat, group.infor = FALSE,
  plot.type = c("estimate", "p.value", "both"), summary.type = c("density",
  "credible.region", "convex.hull"), alpha = 0.95, HistMeanT = NULL,
  HistMeanC = NULL, ind.values = FALSE, impValuesT = NA,
  impValuesC = NA, impValuesColor = NA, show.points = TRUE,
  point.size = 1, point.shape = 19, S = 3, n.grid = 150, ...)
}
\arguments{
\item{outcome}{A  numeric vector of the outcomes, a binary or continuous outcome.}

\item{treat}{A (non-NA) numeric vector of treatment group.}

\item{group.infor}{A logical, whether to display the group information.}

\item{plot.type}{A character, one of "estimate", "p.value" or "both" indicating which one should be represented by a heat-map layer.}

\item{summary.type}{A character, how to summarize the joint posterior distribution of imputed outcomes for  treated and controls, one of "density", "credible.region" or "convex.hull".  see \code{\link[ggplot2]{geom_density2d}},  \code{\link[stats]{mahalanobis}},  \code{\link[ggplot2]{geom_polygon}}, \code{\link[bayesSurv]{credible.region}} for more details.}

\item{alpha}{A numeric between 0-1, with alpha  of points in Convex hull, 1-alpha removed by Machalanobis distance. It also specifies the probabilities for credible regions used in \code{\link[bayesSurv]{credible.region}}, in this case, alpha should be above 0.5 and below 1. The default value is 0.95.}

\item{HistMeanT}{A numeric vector or NULL, historical values or proportions for the treatment group.}

\item{HistMeanC}{A numeric vector or NULL, historical values or proportions for the control group.}

\item{ind.values}{A logical, whether or not to display values in heat-map layer.}

\item{impValuesT}{NA or imputed values for the treatment group, see \code{\link{imputedata}} for more details.}

\item{impValuesC}{NA or imputed values for the control group, see \code{\link{imputedata}} for more details.}

\item{impValuesColor}{NA or imputed colors correspond to the columns in impValuesT or impValuesC. The default colors are from \emph{Set1} in \strong{RColorBrewer} allowing up to 9. Specify explicitly if need more colors.  See \code{\link[RColorBrewer]{display.brewer.all}} for more colors.}

\item{show.points}{A logical, whether to show the points for imputed values.}

\item{point.size}{Size of points for imputed values.}

\item{point.shape}{Shape of points for imputed values.}

\item{S}{A integer indicating range of plotting, the default value is 3.}

\item{n.grid}{A integer, number of points in the grid, only for continuous case, the default is 150.}

\item{\dots}{Additional arguments}
}
\description{
The default method for enhanced tipping point displays.
}
\examples{
#  See more details in vignette using:
#  vignette("TippingPoint")
TippingPoint(outcome=tippingdata$binary,treat= tippingdata$treat,
 plot.type = "p.value",ind.values = TRUE,
 impValuesT  = imputedata[,c("MAR_T2","MCAR_T2")],
 impValuesC = imputedata[,c("MAR_C2","MCAR_C2")],
 impValuesColor = RColorBrewer::brewer.pal(8,"Accent")[c(4,6)],
 summary.type = "credible.region", alpha = 0.95,
 S=1.5, n.grid = 100, HistMeanT = c(0.38,0.4), HistMeanC =  c(0.2,0.55))
}
\seealso{
\code{\link{TippingPoint}}, \code{\link{TippingPoint.formula}}.
}

