% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-distribution-comparison.R
\name{tidy_distribution_comparison}
\alias{tidy_distribution_comparison}
\title{Compare Empirical Data to Distributions}
\usage{
tidy_distribution_comparison(
  .x,
  .distribution_type = "continuous",
  .round_to_place = 3
)
}
\arguments{
\item{.x}{The data set being passed to the function}

\item{.distribution_type}{What kind of data is it, can be one of \code{continuous}
or \code{discrete}}

\item{.round_to_place}{How many decimal places should the parameter estimates
be rounded off to for distibution construction. The default is 3}
}
\value{
An invisible list object. A tibble is printed.
}
\description{
Compare some empirical data set against different distributions
to help find the distribution that could be the best fit.
}
\details{
The purpose of this function is to take some data set provided and
to try to find a distribution that may fit the best. A parameter of
\code{.distribution_type} must be set to either \code{continuous} or \code{discrete} in order
for this the function to try the appropriate types of distributions.

The following distributions are used:

Continuous:
\itemize{
\item tidy_beta
\item tidy_cauchy
\item tidy_exponential
\item tidy_gamma
\item tidy_logistic
\item tidy_lognormal
\item tidy_normal
\item tidy_pareto
\item tidy_uniform
\item tidy_weibull
}

Discrete:
\itemize{
\item tidy_binomial
\item tidy_geometric
\item tidy_hypergeometric
\item tidy_poisson
}

The function itself returns a list output of tibbles. Here are the tibbles that
are returned:
\itemize{
\item comparison_tbl
\item deviance_tbl
\item total_deviance_tbl
\item aic_tbl
\item kolmogorov_smirnov_tbl
\item multi_metric_tbl
}

The \code{comparison_tbl} is a long \code{tibble} that lists the values of the \code{density}
function against the given data.

The \code{deviance_tbl} and the \code{total_deviance_tbl} just give the simple difference
from the actual density to the estimated density for the given estimated distribution.

The \code{aic_tbl} will provide the \code{AIC} for a \code{lm} model of the estimated density
against the emprical density.

The \code{kolmogorov_smirnov_tbl} for now provides a \code{two.sided} estimate of the
\code{ks.test} of the estimated density against the empirical.

The \code{multi_metric_tbl} will summarise all of these metrics into a single tibble.
}
\examples{
xc <- mtcars$mpg
output_c <- tidy_distribution_comparison(xc, "continuous")

xd <- trunc(xc)
output_d <- tidy_distribution_comparison(xd, "discrete")

output_c

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Empirical}
