% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-tidy-distributions-tbl.R
\name{tidy_combine_distributions}
\alias{tidy_combine_distributions}
\title{Combine Multiple Tidy Distributions of Different Types}
\usage{
tidy_combine_distributions(...)
}
\arguments{
\item{...}{The \code{...} is where you can place your different distributions}
}
\value{
A tibble
}
\description{
This allows a user to specify any \code{n} number of \code{tidy_}
distributions that can be combined into a single tibble. This is the preferred
method for combining multiple distributions of different types, for example
a Gaussian distribution and a Beta distribution.

This generates a single tibble with an added column of dist_type that will
give the distribution family name and its associated parameters.
}
\details{
Allows a user to generate a tibble of different \code{tidy_} distributions
}
\examples{

tn <- tidy_normal()
tb <- tidy_beta()
tc <- tidy_cauchy()

tidy_combine_distributions(tn, tb, tc)

## OR

tidy_combine_distributions(
  tidy_normal(),
  tidy_beta(),
  tidy_cauchy(),
  tidy_logistic()
)

}
\seealso{
Other Multiple Distribution: 
\code{\link{tidy_multi_single_dist}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Multiple Distribution}
