% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_operators.R
\docType{methods}
\name{constraints-operators}
\alias{constraints-operators}
\alias{subsetConstraints}
\alias{combineConstraints}
\alias{[,constraints,numeric-method}
\alias{[,constraints,numeric,ANY,ANY-method}
\alias{c,constraints-method}
\title{Basic operators for constraints objects}
\usage{
subsetConstraints(x, i = NULL)

combineConstraints(x1, x2)

\S4method{[}{constraints,numeric}(x, i, j, ..., drop = TRUE)

\S4method{c}{constraints}(x, ...)
}
\arguments{
\item{x, x1, x2}{a \code{\linkS4class{constraints}} object.}

\item{i, j}{indices to use in subsetting.}

\item{...}{not used, exists for compatibility.}

\item{drop}{not used, exists for compatibility.}
}
\description{
Create a subset of a \code{\linkS4class{constraints}} object:

\itemize{
  \item{\code{constraints[i]}}
  \item{\code{subsetConstraints(constraints, 1:10)}}
}

Combine two \code{\linkS4class{constraints}} objects:

\itemize{
  \item{\code{c(constraints1, constraints2)}}
  \item{\code{combineConstraints(constraints1, constraints2)}}
}
}
\examples{
c1 <- constraints_science
c2 <- c1[1:10]
c3 <- c1[c(1, 11:36)] # keep constraint 1 for test length
c4 <- c(c2, c3)

}
