% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\name{STA}
\alias{STA}
\title{Perform shadow test assembly}
\usage{
STA(constraints, objective, solver = "Lpsolve", xmat = NULL,
  xdir = NULL, xrhs = NULL, maximize = TRUE, mps = FALSE,
  lp = FALSE, verbosity = -2, time_limit = 5, gap_limit = NULL,
  gap_limit_abs = NULL, ...)
}
\arguments{
\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}

\item{objective}{A vector of objective values.}

\item{solver}{The type of solver. Accepts \code{SYMPHONY, GUROBI, GLPK, LPSOLVE}.}

\item{xmat}{A matrix of additional constraint coefficients for any previously administered items.}

\item{xdir}{A character vector with the directions for the constraints in \code{xmat}.}

\item{xrhs}{A vector of right-side values for the constraints in \code{xmat}.}

\item{maximize}{If \code{TRUE}, treat as a maximization problem. Otherwise treat as a minimization problem.}

\item{mps}{Only used when \code{solver} is \code{SYMPHONY}. If \code{TRUE}, print an MPS representation of the problem for debugging purposes.}

\item{lp}{Only used when \code{solver} is \code{SYMPHONY}. If \code{TRUE}, print an LP representation of the problem for debugging purposes.}

\item{verbosity}{Verbosity level.}

\item{time_limit}{Time limit passed onto the solver.}

\item{gap_limit}{Gap limit (relative) passed onto the solver. Used in solver \code{GUROBI}.}

\item{gap_limit_abs}{Gap limit (absolute) passed onto the solver. Used in solver \code{SYMPHONY}.}

\item{...}{Only used when \code{solver} is \code{SYMPHONY}. Additional parameters to be passed onto the solver.}
}
\value{
A list containing the optimal solution and pertinent diagnostics.
}
\description{
Perform Shadow Test Assembly (STA) for computerized adaptive testing.
}
\references{
{
  \insertRef{van_der_linden_model_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_2000}{TestDesign}

  \insertRef{van_der_linden_linear_2005}{TestDesign}
}
}
