% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcHessian}
\alias{calcHessian}
\alias{calcHessian,item_1PL,numeric,numeric-method}
\alias{calcHessian,item_1PL,numeric-method}
\alias{calcHessian,item_2PL,numeric,numeric-method}
\alias{calcHessian,item_2PL,numeric-method}
\alias{calcHessian,item_3PL,numeric,numeric-method}
\alias{calcHessian,item_3PL,numeric-method}
\alias{calcHessian,item_PC,numeric,numeric-method}
\alias{calcHessian,item_PC,numeric-method}
\alias{calcHessian,item_GPC,numeric,numeric-method}
\alias{calcHessian,item_GPC,numeric-method}
\alias{calcHessian,item_GR,numeric,numeric-method}
\alias{calcHessian,item_GR,numeric-method}
\alias{calcHessian,item_pool,numeric,numeric-method}
\alias{calcHessian,item_pool,numeric-method}
\alias{calcHessian,pool_cluster,numeric,list-method}
\alias{calcHessian,pool_cluster,numeric-method}
\title{Calculate second derivative of log-likelihood}
\usage{
calcHessian(object, theta, resp)

\S4method{calcHessian}{item_1PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_2PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_3PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_PC,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_GPC,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_GR,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_pool,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{pool_cluster,numeric,list}(object, theta, resp)
}
\arguments{
\item{object}{An instance of an item class.}

\item{theta}{A vector of theta values.}

\item{resp}{Response data.}
}
\value{
Second derivative values of log-likelihoods.
}
\description{
An S4 generic and its methods to calculate the second derivative of the log-likelihood function.
}
\examples{
item_1   <- new("item_1PL", difficulty = 0.5)
h_item_1 <- calcHessian(item_1, seq(-3, 3, 1), 0)
item_2   <- new("item_2PL", slope = 1.0, difficulty = 0.5)
h_item_2 <- calcHessian(item_2, seq(-3, 3, 1), 0)
item_3   <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
h_item_3 <- calcHessian(item_3, seq(-3, 3, 1), 0)
item_4   <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
h_item_4 <- calcHessian(item_4, seq(-3, 3, 1), 0)
item_5   <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
h_item_5 <- calcHessian(item_5, seq(-3, 3, 1), 0)
item_6   <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)
h_item_6 <- calcHessian(item_6, seq(-3, 3, 1), 0)
h_itempool <- calcHessian(itempool_science, seq(-3, 3, 1), 0)
}
\references{
{
  \insertRef{rasch_probabilistic_1960}{TestDesign}
}

{
  \insertRef{lord_theory_1952}{TestDesign}

  \insertRef{birnbaum_efficient_1957}{TestDesign}

  \insertRef{birnbaum_estimation_1958}{TestDesign}

  \insertRef{birnbaum_further_1958}{TestDesign}
}

{
  \insertRef{birnbaum_latent_1968}{TestDesign}
}

{
  \insertRef{masters_rasch_1982}{TestDesign}

  \insertRef{andrich_rating_1978}{TestDesign}
}

{
  \insertRef{muraki_generalized_1992}{TestDesign}
}

{
  \insertRef{samejima_estimation_1969}{TestDesign}
}
}
