% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FwerMethods.R
\name{maxTinftyCor}
\alias{maxTinftyCor}
\title{Multiple testing method of Drton & Perlman (2007) for correlations.}
\usage{
maxTinftyCor(data, alpha = 0.05, stat_test = "empirical",
  Nboot = 1000, OmegaChap = covDcorNorm(cor(data), stat_test),
  vect = FALSE, logical = FALSE, arr.ind = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing (used if logical=TRUE)}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{   \eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{  \eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'2nd.order'}{ \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{Nboot}{number of iterations for Monte-Carlo quantile evaluation}

\item{OmegaChap}{matrix of covariance of empirical correlations used for quantile evaluation;
optional, useful for oracle estimation and step-down}

\item{vect}{if TRUE returns a vector of adjusted p-values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing the adjusted p-values for each entry of the correlation matrix}

\item{logical}{if TRUE, returns either a vector or a matrix where each element is equal to TRUE if the corresponding null hypothesis is rejected, and to FALSE if it is not rejected}

\item{arr.ind}{if TRUE, returns the indexes of the significant correlations, with respect to level alpha}
}
\value{
Returns  \itemize{\item{the adjusted p-values, as a vector or a matrix depending of the value of \code{vect},} \item{an array containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significant, if \code{arr.ind=TRUE}.}}
}
\description{
Multiple testing method based on the evaluation of quantile by simulation of observations 
from the asymptotic distribution (Drton & Perlman (2007)).
}
\examples{
 
n <- 100
p <- 10
corr_theo <- diag(1,p)
corr_theo[1,3] <- 0.5
corr_theo[3,1] <- 0.5
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
# adjusted p-values
res <- maxTinftyCor(data,stat_test='empirical',Nboot=1000)
round(res,2)
# significant correlations with level alpha:
alpha <- 0.05
whichCor(res<alpha)
# directly
res <- maxTinftyCor(data,alpha,stat_test='empirical',Nboot=1000,arr.ind=TRUE)
}
\references{
Drton, M., & Perlman, M. D. (2007). Multiple testing and error control in Gaussian graphical model selection. Statistical Science, 22(3), 430-449.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.
}
\seealso{
ApplyFwerCor, maxTinftyCor_SD
}
