% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPlot.R
\name{TernaryPlot}
\alias{TernaryPlot}
\alias{HorizontalGrid}
\title{Ternary Plot}
\usage{
TernaryPlot(alab = NULL, blab = NULL, clab = NULL, lab.cex = 1,
  lab.font = 2, isometric = TRUE, padding = 0.04, col = NA,
  grid.lines = 10, grid.col = "grey", grid.lty = "dotted",
  grid.lwd = par("lwd"), axis.lty = "solid", axis.labels = TRUE,
  axis.cex = 0.8, axis.font = par("font"), axis.tick = TRUE,
  axis.lwd = 1, ticks.lwd = axis.lwd, axis.col = "black",
  ticks.col = grid.col, ...)

HorizontalGrid(grid.lines = 10, grid.col = "grey", grid.lty = "dotted",
  grid.lwd = par("lwd"))
}
\arguments{
\item{alab, blab, clab}{Character specifying the title for the topmost,
bottommost and leftmost corners respectively.}

\item{lab.cex}{Numeric specifying character expansion for axis titles.}

\item{lab.font}{Numeric specifying font (roman, bold, italic, bold-italic) for axis titles.}

\item{isometric}{Logical specifying whether to enforce an equilateral 
shape for the ternary plot.}

\item{padding}{Numeric specifying size of internal margin of the plot; increase
if axis labels are being clipped.}

\item{col}{The colour for filling the plot; see \link[graphics]{polygon}.}

\item{grid.lines}{The number of grid lines to plot.}

\item{grid.col}{The colour to draw the grid lines.}

\item{grid.lty}{Character or (integer) numeric; line type of the grid lines.}

\item{grid.lwd}{Non-negative numeric giving line width of the grid lines.}

\item{axis.lty}{Line type for both the axis line and tick marks}

\item{axis.labels}{This can either be a logical value specifying whether 
(numerical) annotations are to be made at the tickmarks,
 or a character or expression vector of labels to be
 placed at the tickpoints.}

\item{axis.cex}{Numeric specifying character expansion for axis labels.}

\item{axis.font}{Font for text. Defaults to \code{par('font')}.}

\item{axis.tick}{Logical specifying whether to mark the axes with tick marks.}

\item{axis.lwd, ticks.lwd}{Line width for the axis line and tick marks. 
Zero or negative values will suppress the line or ticks.}

\item{axis.col, ticks.col}{Colours for the axis line and tick marks respectively. 
\code{axis.col = NULL} means to use \code{par("fg")}, possibly specified 
inline, and \code{ticks.col = NULL} means to use whatever colour
\code{axis.col} resolved to.}

\item{\dots}{Additional parameters to \code{\link[graphics]{plot}}.}
}
\description{
Create a blank ternary plot, rotated so that its left edge is vertical.
}
\section{Functions}{
\itemize{
\item \code{HorizontalGrid}: Add horizontal lines to the ternary plot
}}

\examples{
{
TernaryPlot(alab="Top", blab="Bottom", clab="Right", border="red", col=rgb(0.8, 0.8, 0.8))
}

}
\author{
Martin R. Smith
}
\keyword{internal}
