% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortest_ly.R
\name{fortest_ly}
\alias{fortest_ly}
\title{Visualize of the Fitted and the Forecasted vs the Actual Values}
\usage{
fortest_ly(actual, forecast.obj, train, test, Ygrid = FALSE, Xgrid = FALSE)
}
\arguments{
\item{actual}{the full time series object (support "ts", "zoo" and "xts" formats)}

\item{forecast.obj}{The forecast output of the training set with horizon align to the length of the testing (support forecasted objects from the “forecast” package)}

\item{train}{the training partition, a subset of the first n observation in the series}

\item{test}{the testing (hold-out) partition}

\item{Ygrid}{logic,show the Y axis grid if set to TRUE}

\item{Xgrid}{logic,show the X axis grid if set to TRUE}
}
\description{
Visualize the fitted values of the training set and the forecast values of the testing set against the actual values of the series
}
\examples{
\dontrun{
library(forecast)
h <- 12
train <- window(AirPassengers, 
               start = time(AirPassengers)[1], 
               end = time(AirPassengers)[length(AirPassengers) - h])
test <- window(AirPassengers, 
              start = time(AirPassengers)[length(AirPassengers) - h + 1], 
              end = time(AirPassengers)[length(AirPassengers)])

fc <- forecast(auto.arima(train, lambda = BoxCox.lambda(train)), h = h)

fortest_ly(actual = AirPassengers, forecast.obj = fc, train = train, test = test)
}
}
