% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{denorm_z}
\alias{denorm_z}
\title{Z-score denormalisation}
\usage{
denorm_z(x, mean, sd)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{mean}{the mean value}

\item{sd}{the standard deviation value}
}
\value{
the numeric vector of denormalised values
}
\description{
The \code{denorm_z} denormalises time series by z-score method.
}
\examples{
# Normalise values and save normalisation parameters:
norm_res <- norm_z_list(rnorm(50, 5, 2))
# Denormalise new data with previous computed parameters:
denorm_z(rnorm(50, 4, 2), mean = norm_res$mean, sd = norm_res$sd)

}
\references{
Laurinec P, Lucká M (2018)
Clustering-based forecasting method for individual consumers electricity load using time series representations.
Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
}
\seealso{
\code{\link[TSrepr]{norm_z}, \link[TSrepr]{norm_z_list}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
