% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_ots_dts.R
\name{dtSweep}
\alias{dtSweep}
\title{DTS–QCA: Two-dimensional X–Y threshold sweep}
\usage{
dtSweep(
  dat,
  Yvar,
  Xvars,
  sweep_list_X,
  sweep_range_Y,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 2,
  pri.cut = 0.5,
  return_details = FALSE
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{Yvar}{Character. Outcome variable name.}

\item{Xvars}{Character vector. Names of condition variables.}

\item{sweep_list_X}{Named list. Each element is a numeric vector of
candidate thresholds for the corresponding X.}

\item{sweep_range_Y}{Numeric vector. Candidate thresholds for Y.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize}.}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{return_details}{Logical. If \code{TRUE}, returns both summary and
detailed objects.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{combo_id} — index of the X-threshold combination
\item \code{thrY} — threshold for Y
\item \code{thrX} — character label summarizing the X thresholds
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — list of runs with
\code{combo_id}, \code{thrY}, \code{thrX_vec},
\code{truth_table}, \code{solution}
}
}
\description{
Sweeps thresholds for multiple X variables and the outcome Y jointly.
For each combination of X thresholds and each candidate Y threshold, the
data are binarized and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# Quick demonstration with reduced complexity (< 5 seconds)
# Using 2 conditions and 2 threshold levels
sweep_list_X <- list(
  X1 = 6:7,  # Reduced from 6:8 to 6:7
  X2 = 6:7   # Reduced from 6:8 to 6:7
)

sweep_range_Y <- 6:7  # Reduced from 6:8 to 6:7

# Run dual threshold sweep with reduced parameters
# This explores 2 × 2^2 = 8 threshold combinations
result_quick <- dtSweep(
  dat = sample_data,
  Yvar = "Y",
  Xvars = c("X1", "X2"),  # Reduced from 3 to 2 conditions
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y
)
head(result_quick)

\donttest{
# Full analysis with all conditions and thresholds
# This explores 3 × 3^3 = 81 threshold combinations (takes ~10-15 seconds)
sweep_list_X_full <- list(
  X1 = 6:8,
  X2 = 6:8,
  X3 = 6:8
)

sweep_range_Y_full <- 6:8

result_full <- dtSweep(
  dat = sample_data,
  Yvar = "Y",
  Xvars = c("X1", "X2", "X3"),
  sweep_list_X = sweep_list_X_full,
  sweep_range_Y = sweep_range_Y_full
)

# Analyze threshold-dependent causal structures
head(result_full)
}
}
