% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.r
\name{sw}
\alias{sw}
\title{Generating sliding windows of data}
\usage{
sw(x, k)
}
\arguments{
\item{x}{A vector or univariate time series from which the sliding
windows are to be extracted.}

\item{k}{Numeric value corresponding to the required size (length) 
of each sliding window.}
}
\value{
A numeric matrix of size (length(\code{x})-\code{k}+1)
by \code{k}, where each line is a sliding window.
}
\description{
The function extracts all possible subsequences (of the same length) of a
time series (or numeric vector), generating a set of sliding windows of
data, often used to train machine learning methods.
}
\details{
The function returns all (overlapping) subsequences of size \code{swSize} of
\code{timeseries}.
}
\examples{

data("CATS")
s <- sw(CATS[,1],4)

}
\references{
Lampert, C. H., Blaschko, M. B., and Hofmann, T. (2008). Beyond
sliding windows: Object localization by efficient subwindow search. In
Computer Vision and Pattern Recognition, 2008. CVPR 2008. IEEE Conference
on, pages 1-8. IEEE.

Keogh, E. and Lin, J. (2005). Clustering of time series subsequences is
meaningless: Implications for previous and future research. Knowledge and
Information Systems, 8(2):154-177.
}
\author{
Rebecca Pontes Salles
}
\keyword{series}
\keyword{sliding}
\keyword{time}
\keyword{windows}
