% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{coef_TSLA}
\alias{coef_TSLA}
\title{Get coefficients from a fitted TSLA model}
\usage{
coef_TSLA(object, ...)
}
\arguments{
\item{object}{A fit output from \code{TSLA.fit()}.}

\item{...}{Other parameters.}
}
\value{
A list of coefficients for each combination of \eqn{\lambda} and
\eqn{\alpha}.
The first dimension is indexed by the coefficient,
the second dimension is indexed by \eqn{\lambda},
and the third dimension is
indexed by \eqn{\alpha}.
\item{Intercept}{Intercept.}
\item{cov.coef}{Coefficients for unpenalized features.}
\item{gamma.coef}{Node coefficients. Also see details in \code{getetmat()}.}
\item{beta.coef}{Regression coefficients. Each coefficient is multiplied by
\eqn{(-1)^{r-1}}, where r is the order of the corresponding interaction term.
Also see details in \code{getetmat()}.}
\item{beta.coef.adj}{Regression coefficients \eqn{\beta}.
This is the common regression coefficient vector.
It corresponds to \code{x.expand.adj} and
\code{A.adj}.}
}
\description{
Get coefficients from a TSLA.fit object.
}
