% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMSE.R
\name{PMSE}
\alias{PMSE}
\title{Prediction and mean squared error.}
\usage{
PMSE(x, y, B)
}
\arguments{
\item{x}{A predictor tensor, array, matrix or vector.}

\item{y}{A response tensor, array, matrix or vector.}

\item{B}{An coefficient tensor tensor, array, matrix or vector.}
}
\value{
\item{mse}{The mean squared error.}
\item{pred}{The predictions.}
}
\description{
Evaluate the tensor response regression (TRR) or tensor predictor regression (TPR) model through the mean squared error.
}
\details{
There are three situations:
\itemize{
 \item TRR model: If \code{y} is an \eqn{m}-way tensor (array), \code{x} should be matrix or vector and \code{B} should be tensor or array.
 \item TPR model: If \code{x} is an \eqn{m}-way tensor (array), \code{y} should be matrix or vector and \code{B} should be tensor or array.
 \item Other: If \code{x} and \code{y} are both matrix or vector, \code{B} should be matrix. In this case, the prediction is calculated as \code{pred = B*X}.
}

In any cases, users are asked to ensure the dimensions of \code{x}, \code{y} and \code{B} match. See \code{\link{TRRsim}} and \code{\link{TPRsim}} for more details of the TRR and TPR models.

Let \eqn{\hat{Y}_i} denote each prediction, then the mean squared error is defined as \eqn{1/n\sum_{i=1}^n||Y_i-\hat{Y}_i||_F^2}, where \eqn{||\cdot||_F} denotes the Frobenius norm.
}
\examples{
## Dataset in TRR model
r <- c(10, 10, 10)
u <- c(2, 2, 2)
p <- 5
n <- 100
dat <- TRRsim(r = r, p = p, u = u, n = n)
x <- dat$x
y <- dat$y

# Fit data with TRR.fit
fit_std <- TRR.fit(x, y, method="standard")
result <- PMSE(x, y, fit_std$coefficients)
## Dataset in TPR model
p <- c(10, 10, 10)
u <- c(1, 1, 1)
r <- 5
n <- 200
dat <- TPRsim(p = p, r = r, u = u, n = n)
x <- dat$x
y <- dat$y

# Fit data with TPR.fit
fit_std <- TPR.fit(x, y, u, method="standard")
result <- PMSE(x, y, fit_std$coefficients)

}
\seealso{
\code{\link{TRRsim}, \link{TPRsim}}.
}
