% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_merge.R
\name{table_merge}
\alias{table_merge}
\title{Table merge used to merge multiple variables to on variable.}
\usage{
table_merge(
  data,
  merge_vars = c("biological_process", "cellular_component", "molecular_function"),
  new_var = "go_category",
  new_value = "go_term",
  na_remove = FALSE
)
}
\arguments{
\item{data}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{merge_vars}{Vector: include merged variable (column) names. Default: c("Ozone", "Solar.R", "Wind", "Temp") in example data.}

\item{new_var}{Character: new variable (column) name. Default: "Variable".}

\item{new_value}{Character: new variable (column) value name. Default: "Value".}

\item{na_remove}{Logical: remove NA value. Default: FALSE, options: TRUE, FALSE.}
}
\value{
Table: include multiple variables.
}
\description{
Table merge used to merge multiple variables to on variable.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
res <- table_merge(gene_go_kegg)
head(res)

# 4. Set new_var = "GO", new_value = "Terms"
res <- table_merge(gene_go_kegg, new_var = "GO", new_value = "Terms")
head(res)

}
\author{
benben-miao
}
