% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_enrich.R
\name{go_enrich}
\alias{go_enrich}
\title{GO enrichment analysis based on GO annotation results (None/Exist Reference Genome).}
\usage{
go_enrich(
  go_anno,
  degs_list,
  padjust_method = "fdr",
  pvalue_cutoff = 0.05,
  qvalue_cutoff = 0.05
)
}
\arguments{
\item{go_anno}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{degs_list}{Dataframe: degs list.}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}
}
\value{
Table: include columns ("ID", "ontology", "Description", "GeneRatio", "BgRatio", "pvalue", "p.adjust", "qvalue", "geneID", "Count").
}
\description{
GO enrichment analysis based on GO annotation results (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
res <- go_enrich(gene_go_kegg[,-5], gene_go_kegg[100:200,1])
head(res)

# 4. Set padjust_method = "BH"
res <- go_enrich(gene_go_kegg[,-5], gene_go_kegg[100:200,1], padjust_method = "BH")
head(res)

# 5. Set pvalue_cutoff = 0.10
res <- go_enrich(gene_go_kegg[,-5], gene_go_kegg[100:200,1], pvalue_cutoff = 0.10)
head(res)

}
\author{
benben-miao
}
