% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_plot.R
\name{venn_plot}
\alias{venn_plot}
\title{Venn plot for stat common and unique gene among multiple sets.}
\usage{
venn_plot(
  data,
  line_type = "blank",
  ellipse_shape = "circle",
  sci_fill_color = "Sci_AAAS",
  sci_fill_alpha = 0.65
)
}
\arguments{
\item{data}{Dataframe: multiple gene sets as columns.}

\item{line_type}{Character: ellipse border line type. Default: "blank", options: "blank", "solid", "dashed", "dotted", "dotdash", "longdash", "twodash".}

\item{ellipse_shape}{Character: ellipse shape. Default: "circle", options: "circle", "ellipse".}

\item{sci_fill_color}{Character: ggsci color palette. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_fill_alpha}{Numeric: ggsci fill color alpha. Default: 0.65, min: 0.00, max: 1.00.}
}
\value{
Plot: venn plot for stat common and unique gene among multiple sets.
}
\description{
Venn plot for stat common and unique gene among multiple sets.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(venn_data)

# 3. Default parameters
venn_plot(venn_data)

# 4. Set line_type = "dashed"
venn_plot(venn_data, line_type = "dashed")

# 5. Set ellipse_shape = "ellipse"
venn_plot(venn_data, ellipse_shape = "ellipse")

# 6. Set sci_fill_color = "Sci_IGV"
venn_plot(venn_data, sci_fill_color = "Sci_IGV")

}
\author{
benben-miao
}
