% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOSTr.R
\name{TOSTr}
\alias{TOSTr}
\title{TOST function for a correlations}
\usage{
TOSTr(n, r, low_eqbound_r, high_eqbound_r, alpha, plot = TRUE, verbose = TRUE)
}
\arguments{
\item{n}{number of pairs of observations}

\item{r}{observed correlation}

\item{low_eqbound_r}{lower equivalence bounds (e.g., -0.3) expressed in a correlation effect size}

\item{high_eqbound_r}{upper equivalence bounds (e.g., 0.3) expressed in a correlation effect size}

\item{alpha}{alpha level (default = 0.05)}

\item{plot}{set whether results should be plotted (plot = TRUE) or not (plot = FALSE) - defaults to TRUE}

\item{verbose}{logical variable indicating whether text output should be generated (verbose = TRUE) or not (verbose = FALSE) - default to TRUE}
}
\value{
Returns TOST p-value 1, TOST p-value 2, alpha, low equivalence bound r, high equivalence bound r, Lower limit confidence interval TOST, Upper limit confidence interval TOST
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Development on \code{TOSTr} is complete, and for new code we recommend
switching to \link{corsum_test}, which is easier to use, more featureful,
and still under active development.
}
\section{References}{

Goertzen, J. R., & Cribbie, R. A. (2010). Detecting a lack of association: An equivalence testing approach. British Journal of Mathematical and Statistical Psychology, 63(3), 527-537. https://doi.org/10.1348/000711009X475853, formula page 531.
}

\examples{
TOSTr(n=100, r = 0.02, low_eqbound_r=-0.3, high_eqbound_r=0.3, alpha=0.05)
}
