% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{Get or set internal configuration variables}
\usage{
config(..., DLL = getUserDLL())
}
\arguments{
\item{...}{Variables to set}

\item{DLL}{Name of user's DLL. Auto-detected if missing.}
}
\value{
List with current configuration
}
\description{
Get or set internal configuration variables of user's DLL.
}
\details{
A model compiled with the \code{TMB} C++ library has several
configuration variables set by default. The variables can be read
and modified using this function. The meaning of the variables can
be found in the Doxygen documentation.
}
\examples{
\dontrun{
## Load library
dyn.load(dynlib("mymodel"))
## Read the current settings
config(DLL="mymodel")
## Reduce memory peak of a parallel model by creating tapes in serial
config(tape.parallel=0, DLL="mymodel")
obj <- MakeADFun(..., DLL="mymodel")
}
}

