% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxOR.R
\name{findCutoffs}
\alias{findCutoffs}
\title{Finding the two cut-off points}
\usage{
findCutoffs(spm.fit, dataC)
}
\arguments{
\item{spm.fit}{Fitted semi-parametric model object}

\item{dataC}{Data frame containing age and binary outcome variables}
}
\value{
Data frame containing age, fitted lnOR, OR, se, sp, sse, and ssp
}
\description{
Finding the two cut-off points
}
\examples{
# Generate simulated data dataC
dataC <- createData(200)

# Fit the semi-parametric model
spm.fit <- fitSemiParamModel(dataC)

# Find two cut-off points
dataC <- findCutoffs(spm.fit, dataC)
}
