% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_TAG.R
\name{pred.TAG}
\alias{pred.TAG}
\title{Prediction from the TAG process}
\usage{
pred.TAG(object, newX)
}
\arguments{

\item{object}{object of class inheriting from "TAG".}

\item{newX}{matrix of new x values at which predictions are needed.}
}
\description{
This function provides predictions from a TAG process.
}
\value{
The values returned from the function are the predictions  at newX.
}
\references{
Lin, L.-H. and Joseph,  V. R. (2019+) "Transformation and Additivity in Gaussian Processes", \emph{Technometrics, to appear}.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{TAG}} for the estimates of the parameters in the TAG.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
N <- 1000
X.test <- sobol(N, dim = p, init = TRUE, scrambling = 2, seed = 5, normal = FALSE)
ytrue  <- exp(2*sin(0.5*pi*X.test[,1]) + 0.5*cos(2.5*pi*X.test[,2]))
pre.TAG <- pred.TAG(par.TAG, X.test)
}
\keyword{Predictions}
\keyword{TAG}
