% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen.R
\name{rBNR}
\alias{rBNR}
\title{Simulate Bivariate Normal Data with Missingness}
\usage{
rBNR(X, Z, b, a, t_miss = 0, s_miss = 0, sigma = NULL)
}
\arguments{
\item{X}{Target design matrix.}

\item{Z}{Surrogate design matrix.}

\item{b}{Target regression coefficient.}

\item{a}{Surrogate regression coefficient.}

\item{t_miss}{Target missingness in [0,1].}

\item{s_miss}{Surrogate missingness in [0,1].}

\item{sigma}{2x2 target-surrogate covariance matrix.}
}
\value{
Numeric Nx2 matrix. The first column contains the target
  outcome, the second contains the surrogate outcome.
}
\description{
Function to simulate from a bivariate normal regression model with outcomes
missing completely at random.
}
\examples{
set.seed(100)
# Observations.
n <- 1e3
# Target design.
X <- cbind(1, matrix(rnorm(3 * n), nrow = n))
# Surrogate design.
Z <- cbind(1, matrix(rnorm(3 * n), nrow = n))
# Target coefficient.
b <- c(-1, 0.1, -0.1, 0.1)
# Surrogate coefficient.
a <- c(1, -0.1, 0.1, -0.1)
# Covariance structure.
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
# Data generation, target and surrogate subject to 10\% missingness.
y <- rBNR(X, Z, b, a, t_miss = 0.1, s_miss = 0.1, sigma = sigma)
}
