% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvSurv.R
\name{summary.MetaAnalyticSurvSurv}
\alias{summary.MetaAnalyticSurvSurv}
\title{Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvSurv()' function.}
\usage{
\method{summary}{MetaAnalyticSurvSurv}(object, ...)
}
\arguments{
\item{object}{An object of class 'MetaAnalyticSurvSurv' fitted with the 'MetaAnalyticSurvSurv()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals.
}
\description{
Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvSurv()' function.
}
\examples{
\dontrun{
data("colorectal")
fit <- MetaAnalyticSurvSurv(data=Ovarian,true=Surv,trueind=SurvInd,surrog=Pfs,surrogind=PfsInd,
                            trt=Treat,center=Center,trial=Center,patientid=Patient,
                            copula="Plackett",adjustment="unadjusted")
summary(fit)
}
}
