% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normals.R
\name{getSomeNormals}
\alias{getSomeNormals}
\title{Normals for a points could}
\usage{
getSomeNormals(nbNeighbors, method = "pca")
}
\arguments{
\item{nbNeighbors}{integer, number of neighbors used to compute the normals}

\item{method}{one of \code{"pca"} or \code{"jet"}}
}
\value{
A function which takes just one argument: a numeric matrix with
  three columns, each row represents a point, and the function returns a
  matrix of the same size as the input matrix, whose each row gives one
  unit normal for each point.
}
\description{
Returns a function which computes some normals for a 3D points
  cloud.
}
\note{
The \code{getSomeNormals} function is intended to be used in the
  \code{\link{PoissonReconstruction}} function. If you want to use it for
  another purpose, be careful because the function it returns does not
  check the matrix it takes as argument.
}
\examples{
library(SurfaceReconstruction)
library(rgl)
psr <- PoissonReconstruction(ICN5D_eight, getSomeNormals(6))
open3d()
shade3d(psr, color = "cyan")
wire3d(psr)
}
