% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbm-msd.R
\name{fbm.msd}
\alias{fbm.msd}
\title{Mean square displacement of fractional Brownian motion.}
\usage{
fbm.msd(tseq, H)
}
\arguments{
\item{tseq}{Length-\code{N} vector of timepoints.}

\item{H}{Hurst parameter (between 0 and 1).}
}
\value{
Length-\code{N} vector of mean square displacements.
}
\description{
Mean square displacement of fractional Brownian motion.
}
\details{
The mean squared displacement (MSD) of a stochastic process \eqn{X_t} is defined as
\deqn{
\mathrm{\scriptsize MSD}_X(t) = E[(X_t - X_0)^2].
}{
MSD_X(t) = E[(X_t - X_0)^2].
}
Fractional Brownian motion (fBM) is a continuous Gaussian process with stationary increments, such that its covariance function is entirely defined the MSD, which in this case is \eqn{\textrm{\small MSD}_X(t) = |t|^{2H}}{MSD_X(t) = |t|^(2H)}.
}
\examples{
fbm.msd(tseq = 1:10, H = 0.4)
}
