% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-venn-diagram-function.r
\name{plot_venn}
\alias{plot_venn}
\title{Venn diagram for subgroup effect size}
\usage{
plot_venn(dat, covari.sel, cat.sel, trt.sel, resp.sel, outcome.type,
  fill = TRUE, range.strip = c(-6, 6), n.brk = 13, n.brk.axis = 7,
  effect = "HR", show.overall = TRUE, palette = "divergent",
  col.power = 0.5, font.size = c(1, 1.5, 1, 0.9, 1, 1), title = NULL,
  strip = NULL, cat.dist = rep(0.04, 3), prop_area = FALSE)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of covariates}

\item{cat.sel}{a vector of indices of the categories for each covariate}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{fill}{A logical indicating whether to use color for treatment effects}

\item{range.strip}{a vector with two elements specifying the range of treatment effect size for display}

\item{n.brk}{a number specifying the number of the points dividing the range of the argument "range.strip".}

\item{n.brk.axis}{a number specifying the number of breakpoints dividing the axis of the argument "range.strip".}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{show.overall}{logical. whether to show or not the overall treatment effect in the strip}

\item{palette}{either "divergent" or "hcl"}

\item{col.power}{to be used when palette = "hcl". see colorspace package for reference}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title; the second is for the category labels;
the third is for the sample size labels; the fourth is for the legend text; the fifth is for the y-axis label of the colour strip;
the sixth is for the unit label on the y axis.}

\item{title}{a string specifying the main title.}

\item{strip}{a string specifying the title of the colour strip.}

\item{cat.dist}{A vector (length same as covari.sel) giving the distances (in npc units) of the category names from the edges of the circles (can be negative)}

\item{prop_area}{A logical indicating whether to make the areas approximately proportional to the set size}
}
\description{
This function produces a Venn diagram showing the treatment effect size of subgroups defined by sets from the categories of covariates.
Also, it prints out the minimum and maximum of the treatment effect size on the console so as to set an approapriate range for effect
size on the colour strip . Note that there are two options of graphical display; whether show the subgroup effect size of the complement
of the union of all the considered subgroups or not. In addition, this function only works up to 5 sets and does not run an area-proportional
algorithms for displaying two or three set. In addition, the function uses log odd ratio and log hazard ratio for displaying
subgroup effect sizes in binary and survival data, respectively.
}
\examples{
library(dplyr)
# Load the data to be used
data(prca)

## 3.a Venn Diagram -----------------------------------------------------------
dat <- prca
dat \%>\%
  rename(Performance = pf,
         `Bone\\nmetastasis` = bm,
         `History of\\ncardiovascular\\nevents` = hx) -> dat
plot_venn(dat,
          covari.sel = c(5, 7, 4),
          cat.sel = c(2,2,2),
          trt.sel = 3,
          resp.sel = c(1,2),
          outcome.type = "survival",
          fill = FALSE,
          cat.dist = c(0.04,0.04,0.07),
          font.size = c(0.5, 0.5, 0.7, 0.5, 0.6, 0.6))

## 3.b Filled Venn Diagram -----------------------------------------------------------
dat <- prca
dat$age1 = factor(dat$age1)
dat \%>\%
  rename(Stage = stage,
         Performance = pf,
         `Bone\\nmetastasis` = bm,
         `History of\\ncardiovascular\\nevents` = hx) -> dat
plot_venn(dat,
          covari.sel = c(4,6,7,5),#vars,
          cat.sel = c(2,2,2,2),
          trt.sel = 3,
          resp.sel = c(1,2),
          outcome.type = "survival",
          fill = TRUE,
          range.strip = c(-3, 3),
          n.brk = 31, n.brk.axis = 7,
          font.size = c(0.5, 0.5, 0.7, 0.5, 0.6, 0.6),
          strip = paste("Treatment effect size (log hazard ratio)"),
          palette = "hcl")

\donttest{
## 3.c Area-proportional Venn Diagram -------------------------------------------------------------
dat <- prca
plot_venn(dat,
          covari.sel = c(5,7,4),
          cat.sel = c(2,2,2),
          trt.sel = 3,
          resp.sel = c(1,2),
          outcome.type = "survival",
          fill = TRUE,
          range.strip = c(-3, 3),
          n.brk = 31, n.brk.axis = 7,
          font.size = c(0.5, 0.5, 0.7, 0.5, 0.6, 0.6),
          strip = paste("Treatment effect size (log hazard ratio)"),
          palette = "hcl", prop_area = TRUE)
}



}

