% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-contour-plot-localreg.r
\name{plot_contour_localreg}
\alias{plot_contour_localreg}
\title{Contour plot for effect size via local regression.}
\usage{
plot_contour_localreg(dat, covari.sel, trt.sel, resp.sel, outcome.type,
  setup.ss, n.grid = c(41, 41), brk.es = c(0, 1, 2, 3), n.brk.axis = 3,
  para.plot = c(0.35, 2, 20), font.size = c(1.5, 1.2, 1, 0.85, 0.8),
  title = NULL, subtitle = NULL, unit.x = 1, unit.y = 1,
  effect = "HR", show.overall = TRUE, strip = "Effect Size")
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a variable index specifying the treatment code}

\item{resp.sel}{a variable index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable,
it can be "continuous", or "binary" or  "survival".}

\item{setup.ss}{a vector specifying approximate subgroup sample size
and neibourghing subgroup overlap sample size. The first and the second elements
are for overlap sizes and subgroup sample sizes over the first covariate;
the third and thefourth are for further divided overlap sizes
and subgroup sample sizes over the second covariate.}

\item{n.grid}{a vector specifying the numbers of the grid points on
the x-axis and the y-axis respectively.}

\item{brk.es}{a vector specifying the break points on effect size,
where each range partition is given with a different colour on points.}

\item{n.brk.axis}{a number specifying the number of breakpoints dividing the axis of the argument "range.strip".}

\item{para.plot}{a vector specifying the parameters of the contour plot;
the first value is for controlling the degree of smoothing; the second
                is for controlling the degree of the polynomials fitting to
                be used (normally 1 or 2); the third is for controlling the
                number of contour lines.}

\item{font.size}{a vector specifying the size of labels and text; the
first element is for the main title, the second is for for x-axis and y-axis
labels; the third is for the subtitle; the fourth is for the text in the
legend; the fifth is for the labels on contour lines.}

\item{title}{a string specifying the main title.}

\item{subtitle}{strings specifying the subtitle}

\item{unit.x}{step for the x variable to create the grid that will center the kernel to apply the local regression}

\item{unit.y}{step for the x variable to create the grid that will center the kernel to apply the local regression}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{show.overall}{logical. whether to show or not the overall treatment effect in the strip}

\item{strip}{a string specifying the title of the colour strip.}
}
\description{
this function produces a contour plot showing the treatment effect size of subgroups. The subgroups are first defined by certain
ranges of the first continuous covariate; and then further divided into smaller subgroup by certain ranges of the second covariate
. The subgroups over the first covariate have a sample size close to one pre-specified value (N2) and any neighboring subgroups
have an overlap size near the second pre-specified value (N1). Similarly, each subgroup over the first covariate has a sample size
near the third pre-specified value (N4), and any neighboring subgroups which are further divided over the second covariate have a
sample size near the fourth pre-specified value (N3). The x-coordinate and y-coordinate of a point indicates the middle point of
the range over the first covariate and that over the second covariate, respectively. The contours show approximate effect sizes
which are obtained by fitting grid points over the polynormial surface interpolating the points corresponding to subgroups.Note
that there are three parameters for controlling the setting of contours. In addition, the function uses log odd ratio and log
hazard ratio for displaying subgroup effect sizes in binary and survival data, respectively. Also, the actual subgroup sample
sizes over the covariates are shown on the console window.
}
\examples{
\donttest{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
dat \%>\%
  rename(Weight = weight,
         Age = age) -> dat

plot_contour_localreg(dat,
                      covari.sel = c(8,9),
                      trt.sel = 3,
                      resp.sel = c(1,2),
                      n.grid = c(100,100),
                      font.size = c(1, 1, 1, 1, 1),
                      brk.es = seq(-4.5,4.5,length.out = 101),
                      n.brk.axis =  7,
                      strip = "Treatment effect size (log hazard ratio)",
                      outcome.type = "survival")
}
}

