% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_weibull.R
\name{predict.submod_weibull}
\alias{predict.submod_weibull}
\title{Predict submod: Model-based partitioning (Weibull)}
\usage{
\method{predict}{submod_weibull}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained MOB (Weibull) model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Identified subgroups with subgroup-specific predictions.
\itemize{
  \item Subgrps - Identified subgroups
  \item pred - Predictions, based on weibull regression fit, estimate hazard ratio
  by subgroup.
}
}
\description{
Predict subgroups and obtain subgroup-specific point-estimates (in pprogress).
}
\examples{

\donttest{
library(StratifiedMedicine)
# Survival Data #
require(TH.data); require(coin)
data("GBSG2", package = "TH.data")
surv.dat = GBSG2
# Design Matrices #
Y = with(surv.dat, Surv(time, cens))
X = surv.dat[,!(colnames(surv.dat) \%in\% c("time", "cens")) ]
A = rbinom( n = dim(X)[1], size=1, prob=0.5  ) ## simulate null treatment

res_weibull = submod_weibull(Y, A, X, Xtest=X, family="survival")
out = predict(res_weibull)
plot(res_weibull$mod)
}


}
