% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_ranger.R
\name{ple_ranger}
\alias{ple_ranger}
\title{Patient-level Estimates: Ranger}
\usage{
ple_ranger(Y, A, X, Xtest, byTrt = 1, min.node.pct = 0.1,
  family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{byTrt}{If 1, fit treatment-specific ranger models. If 0, fit a single ranger model
with covariate space (X, A, X*A)}

\item{min.node.pct}{Minimum sample size in forest nodes (n*min.node.pct)}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained random forest (ranger) model(s).
 \itemize{
  \item mods - trained model(s)
  \item A - treatment variable (training set)
  \item X - covariate space (training set)
}
}
\description{
Uses treatment-specific (or with explicit X*A interactions) random forest models (ranger)
to obtain patient-level estimates. Used for continuous, binary, or survival outcomes.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Counter-factual Random Forest (treatment-specific ranger models) #
mod1 = ple_ranger(Y, A, X, Xtest=X)
summary( predict(mod1, newdata=data.frame(A,X) ) ) # oob predictions for training
summary( predict(mod1, newdata=data.frame(X) ) ) # new-predictions, no oob here

}

}
\seealso{
\code{\link{PRISM}}, \code{\link{ranger}}
}
