% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_ranger.R
\name{filter_ranger}
\alias{filter_ranger}
\title{Filter: Random Forest (ranger) Variable Importance}
\usage{
filter_ranger(Y, A, X, b = 0.66, K = 200, DF2 = FALSE, FDR = FALSE,
  pval.thres = 0.1, family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{b}{Subsample size (n^b)}

\item{K}{Number of samples (default=200)}

\item{DF2}{2-DF test statistic (default=FALSE)}

\item{FDR}{FDR correction for p-values (default=FALSE)}

\item{pval.thres}{p-value threshold for filtering (default=0.10)}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Filter model and variables that remain after filtering.
 \itemize{
  \item mod - Filtering model
  \item filter.vars - Variables that remain after filtering (could be all)
}
}
\description{
Filtering through Random Forest Variable Importance with p-values. P-values are obtained
through subsampling based T-statistics, as described in Ishwaran and Lu 2017. Default is
to remove variables with p-values >= 0.10. Used for continuous, binary, or survival
outcomes.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
mod1 = filter_ranger(Y, A, X, K=200) # Same as default #
mod1$filter.vars
mod1$mod # summary of variable importance outputs
}


}
