% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_niche.R
\name{apply_niche}
\alias{apply_niche}
\title{apply niche model}
\usage{
apply_niche(x, niche_def, gc)
}
\arguments{
\item{x}{events type data, e.g. vector of times/ages of fossil occurrences or their stratigraphic position, or a \code{pre_paleoTS} object (e.g. produced by \code{stasis_sl}).}

\item{niche_def}{function, specifying the niche along a gradient. Should return 0 when taxon is outside of niche, and 1 when inside niche. Values between 0 and 1 are interpreted as collection probabilities. Must be vectorized, meaning if given a vector, it must return a vector of equal length.}

\item{gc}{function, stands for "gradient change". Specifies how the gradient changes, e.g. with time. Must be vectorized, meaning if given a vector, it must return a vector of equal length.}
}
\value{
for a numeric vector input, returns a numeric vector, timing/location of events (e.g. fossil ages/locations) preserved after the niche model is applied. For a \code{pre_paleoTS} object as input, returns a \code{pre_paleoTS} object with specimens removed according to the niche model.
}
\description{
Models niches by removing events (fossil occurrences) or specimens when they are outside of their niche. For event type data, this is done using the function \code{thin}, for \code{pre_paleoTS} this is done by applying the function \code{prob_remove} on the specimens.
Combines the functions \code{niche_def} and \code{gc} ("gradient change") to determine how the taxons' collection probability changes with time/position. This is done by composing \code{niche_def} and \code{gc}. The result is then used to remove events/specimens in \code{x}.
}
\examples{
### example for event type data
## setup
# using water depth as gradient
 t = scenarioA$t_myr
 wd = scenarioA$wd_m[,"8km"]
 gc = approxfun(t, wd)
 plot(t, gc(t), type = "l", xlab = "Time", ylab = "water depth [m]",
  main = "gradient change with time")
 # define niche
 # preferred wd 10 m, tolerant to intermediate wd changes (standard deviation 10 m), non-terrestrial
 niche_def = snd_niche(opt = 10, tol = 10, cutoff_val = 0)
 plot(seq(-1, 50, by = 0.5), niche_def(seq(-1, 50, by = 0.5)), type = "l",
 xlab = "water depth", ylab = "collection probability", main = "Niche def")
 # niche pref with time
 plot(t, niche_def(gc(t)), type = "l", xlab = "time",
 ylab = "collection probability", main = "collection probability with time")

 ## simulate fossil occurrences
 foss_occ = p3(rate = 100, from = 0, to = max(t))
 # foss occ without niche pref
 hist(foss_occ, xlab = "time")
 foss_occ_niche = apply_niche(foss_occ, niche_def, gc)
 # fossil occurrences with niche preference
 hist(foss_occ_niche, xlab = "time")

 # see also
 #vignette("event_data")
 # for a detailed example on niche modeling for event type data

 ### example for pre_paleoTS objects
 # we reuse the niche definition and gradient change from above!
 x = stasis_sl(seq(0, max(t), length.out = 10))
 plot(reduce_to_paleoTS(x), main = "Trait evolution before niche modeling")
 y = apply_niche(x, niche_def, gc)
 plot(reduce_to_paleoTS(y), main = "Trait evolution after niche modeling")
 # note that there are fewer sampling sites
 # bc the taxon does not appear everywhere
 # and there are fewer specimens per sampling site

}
\seealso{
\itemize{
\item \code{\link[=snd_niche]{snd_niche()}} and \code{\link[=bounded_niche]{bounded_niche()}} for template niche models
\item \verb{vignette("advanced_functionality)} for how to create user-defined niche models
\item \code{\link[=apply_taphonomy]{apply_taphonomy()}} to model taphonomic effects based on a similar principle
\item \code{\link[=thin]{thin()}} and \code{\link[=prob_remove]{prob_remove()}} for the underlying mathematical procedures
}
}
