% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_ini_xml.R
\name{gen_ini_xml}
\alias{gen_ini_xml}
\title{Generate STICS ini xml file(s) from a template or an input file}
\usage{
gen_ini_xml(
  param_df,
  file = NULL,
  out_dir,
  crop_tag = "Crop",
  stics_version = "latest",
  ini_in_file = lifecycle::deprecated(),
  param_table = lifecycle::deprecated(),
  out_path = lifecycle::deprecated()
)
}
\arguments{
\item{param_df}{A table (df, tibble) containing the values of the parameters
to use (see details)}

\item{file}{Path of an ini xml file to be used as a template. Optional,
if not provided, the function will use a standard template depending on
the STICS version (see \code{stics_version} argument)}

\item{out_dir}{Path of the directory where to generate the file(s).}

\item{crop_tag}{identifier for the crop parameters names related to the
main crop, or the associated crop if any (example: Crop is used in the
param_table example in the details section below)}

\item{stics_version}{Name of the STICS version.
Optional, used if the \code{file} argument is not provided. In this case
the function uses a standard template associated to the STICS version.}

\item{ini_in_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{ini_in_file} is no
longer supported, use \code{file} instead.}

\item{param_table}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{param_table} is no
longer supported, use \code{param_df} instead.}

\item{out_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{out_path} is no
longer supported, use \code{out_dir} instead.}
}
\value{
an invisible xml_document object or a list of
}
\description{
Generate STICS ini xml file(s) from a template or an input file
}
\details{
Please see \code{get_stics_versions_compat()} for the full list of
STICS versions that can be used for the
argument \code{stics_version}.

\code{param_df} is a \code{data.frame} with the following format:\tabular{lrlrr}{
   Ini_name \tab nbplantes \tab stade0_Crop1 \tab lai0_Crop1 \tab masec0_Crop1 \cr
   USM_2017_T1_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill09_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill10_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill11_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill12_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill13_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Vill14_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
   Standard_ini.xml \tab 1 \tab snu \tab 0 \tab 0 \cr
}


The first column gives the ini file name (to be generated), all following
columns give the parameter value to put
in the file, and each line denotes a separate ini file
(for e.g. several USMs).

The first column name must contain the keyword ini or Ini or INI as a prefix
to be detected (as shown in the table extract above).

If not given (the default, \code{NULL}), the function returns the template as is.
}
\examples{
library(readxl)

xl_path <- download_usm_xl(file = "inputs_stics_example.xlsx")

ini_param_df <- read_excel(xl_path, sheet = "Ini")
gen_ini_xml(
  out_dir = tempdir(),
  param_table = ini_param_df
)

}
