% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamppAmova.R
\name{stamppAmova}
\alias{stamppAmova}
\title{Analysis of Molecular Variance}
\usage{
stamppAmova(dist.mat, geno, perm = 100)
}
\arguments{
\item{dist.mat}{the matrix of genetic distances between individuals generated from stamppNeisD()}

\item{geno}{a data frame containing allele frequency data generated from stamppConvert, or a genlight object containing genotype data, individual IDs, population IDs and ploidy levels}

\item{perm}{the number of permutations for the tests of hypotheses}
}
\value{
An object of class "amova" which is a list containing a table of sum of square deviations (SSD), mean square deviations (MSD) and the number of degrees of freedom as well as the variance components
}
\description{
Calculates an AMOVA based on the genetic distance matrix from stamppNeisD() using the amova() function from the package PEGAS for exploring within and between population variation
}
\details{
Uses the formula distance ~ populations, to calculate an AMOVA for population differentiation and within & between population variation.
This function uses the amova function from the PEGAS package.
}
\examples{
# import genotype data and convert to allele frequecies
data(potato.mini, package="StAMPP")
potato.freq <- stamppConvert(potato.mini, "r")
# Calculate genetic distance between individuals
potato.D.ind <- stamppNeisD(potato.freq, FALSE)
# Calculate AMOVA
stamppAmova(potato.D.ind, potato.freq, 100)
}
\references{
Paradis E (2010) pegas: an R package for population genetics with an integrated-modular approach. Bioinformatics 26, 419-420. <doi:10.1093/bioinformatics/btp696>
}
\author{
Luke Pembleton <luke.pembleton at agriculture.vic.gov.au>
}
