\name{StAMPP-package}
\alias{StAMPP-package}
\alias{StAMPP}
\docType{package}
\title{
Statistical Analysis of Mixed Ploidy Populations
}
\description{
Allows users to calculate pairwise Nei's Genetic Distances (Nei 1972), pairwise Fixation
 Indexes (Fst) (Weir & Cockerham 1984) and also Genomic Relationship matrixes following Yang et al. (2010) in mixed and single
 ploidy populations. Bootstrapping across loci is implememted during Fst calculation to generate confidence intervals and p-values
 around pairwise Fst values. StAMPP utilises SNP genotype data of any ploidy level (with the ability to handle missing data) and is coded to  
 utilise multithreading where avaliable to allow efficient analysis of large datasets.
}
\details{
\tabular{ll}{
Package: \tab StAMPP\cr
Type: \tab Package\cr
Version: \tab 1.4\cr
Date: \tab 2015-06-30\cr
License: \tab GPL-3\cr
}
Biallelic AB genotype or frequency of allele A genotype data can be imported into and R and converted into allele frequencies and stored in a data frame using the stamppConvert() function. The resulting allele frequency data frame can be used as the genotype information for;
the calculation of Nei's genetic distance of populations and individuals using the stamppNeisD() function. The resulting genetic distance matrix can be explorted in Phylip format with the stamppPhylip() function.
the calculation of pairwise Fst values, confidence intervals and p-values using the stamppFst() function.
the calculation of a genomic relationship matrix using the stamppGmatrix() function.

All StAMPP functions can also work with genotype data stored in genlight objects rather than the data frame generated by stamppConvert()

Please refer to; LW Pembleton, NOI Cogan & FW Forster, 2013, Molecular Ecology Resources, doi:10.1111/1755-0998.12129 for the appropriate citation and user manual. Thank you in advance.
}
\author{
LW Pembleton

Maintainer: LW Pembleton <luke.pembleton@ecodev.vic.gov.au>
}
\references{
Nei M (1972) Genetic Distance between Populations. The American Naturalist 106, 283-292.

Perrier X, Jacquemound-Collet JP (2006) DARWin - Dissimilarity Analysis and Representation for Windows. Agricultural Research for Development

Weir BS, Cockerham CC (1984) Estimating F Statistics for the Analysis of Population Structure. Evolution 38, 1358-1370.

Wright S (1949) The Genetical Structure of Populations. Annals of Human Genetics 15, 323-354.

Yang J, Benyamin B, McEvoy BP, et al (2010) Common SNPs explain a large proportion of the heritability for human height. Nat Genet 42, 565-569

Paradis E (2010) pegas: an R package for population genetics with an integrated-modular approach. Bioinformatics 26, 419-420.

Jombart T, Ahmed I (2011) adegenet 1.3-1: new tools for the analysis of genome-wide SNP data. Bioinformatics 27, 3070-3071.
}
\keyword{ package }
\seealso{
 \code{\link{stamppConvert}}
  \code{\link{stamppNeisD}}
  \code{\link{stamppFst}}
  \code{\link{stamppGmatrix}}
  \code{\link{stamppAmova}}
  \code{\link{stamppPhylip}}
  \code{\link{stampp2genlight}}
}
\examples{
# import genotype data and convert to allele frequecies 
data(potato.mini, package="StAMPP")
potato.freq <- stamppConvert(potato.mini, "r")

# Calculate genetic distance between populations
potato.D.pop <- stamppNeisD(potato.freq, TRUE)

# Calculate genetic distance between individuals
potato.D.ind <- stamppNeisD(potato.freq, FALSE)

# Calculate AMOVA
stamppAmova(potato.D.ind, potato.freq, 100)

# Export the genetic distance matrix in Phylip format
stamppPhylip(potato.D.pop, file="potato_distance.txt")

# Calculate pairwise Fst values between each population
potato.fst <- stamppFst(potato.freq, 100, 95, 1)

# Calculate genomic relationship values between each individual
potato.gmat <- stamppGmatrix(potato.freq)

# Convert allele frequency genotype data frame to a genlight object for use in other packages
potato.genlight <- stampp2genlight(potato.freq, TRUE)
}
