% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STmodel.R
\name{print.STmodel}
\alias{print.STmodel}
\title{Print details for \code{STmodel} object}
\usage{
\method{print}{STmodel}(x, type = x$locations$type, ...)
}
\arguments{
\item{x}{\code{STmodel} object to print information for.}

\item{type}{Factorial of \code{length(x$locations$ID)}, if not \code{NULL}
the output also presents summaries of number of sites and observations
as well as time periods per type of site.}

\item{...}{Ignored additional arguments.}
}
\value{
Nothing
}
\description{
\code{\link[base:print]{print}} method for class \code{STmodel}.
}
\examples{
##load some data
data(mesa.model)
##print basic information regarding obs, locations, dates, etc
print(mesa.model)

}
\seealso{
Other STmodel methods: \code{\link{MCMC.STmodel}},
  \code{\link{c.STmodel}}, \code{\link{createSTmodel}},
  \code{\link{estimate.STmodel}},
  \code{\link{estimateCV.STmodel}},
  \code{\link{plot.STdata}}, \code{\link{predict.STmodel}},
  \code{\link{print.summary.STmodel}},
  \code{\link{qqnorm.predCVSTmodel}},
  \code{\link{scatterPlot.predCVSTmodel}},
  \code{\link{simulate.STmodel}},
  \code{\link{summary.STmodel}}
}
\author{
Johan Lindstrom
}
