% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{barPlotCellTypes}
\alias{barPlotCellTypes}
\title{Bar plot of deconvoluted cell type proportions}
\usage{
barPlotCellTypes(
  data,
  colors = NULL,
  simplify = NULL,
  color.line = NA,
  x.label = "Spots",
  rm.x.text = FALSE,
  title = "Results of deconvolution",
  legend.title = "Cell types",
  angle = 90,
  theme = NULL,
  index.st = NULL
)
}
\arguments{
\item{data}{\code{\linkS4class{SpatialDDLS}} object with the
\code{deconv.spots} slot containing predicted cell type proportions.}

\item{colors}{Vector of colors to be used.}

\item{simplify}{Type of simplification performed during deconvolution. It can
be \code{simpli.set} or \code{simpli.maj} (\code{NULL} by default).}

\item{color.line}{Color of the border bars.}

\item{x.label}{Label of x-axis.}

\item{rm.x.text}{Logical value indicating whether to remove x-axis ticks
(name of samples).}

\item{title}{Title of the plot.}

\item{legend.title}{Title of the legend plot.}

\item{angle}{Angle of text ticks.}

\item{theme}{\pkg{ggplot2} theme.}

\item{index.st}{Name or index of the element wanted to be shown in the
\code{deconv.spots} slot.}
}
\value{
A ggplot object with the provided cell proportions represented as a
bar plot.
}
\description{
Bar plot of deconvoluted cell type proportions.
}
\seealso{
\code{\link{deconvSpatialDDLS}}
}
