% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{OffShotSeasonGraphTeam}
\alias{OffShotSeasonGraphTeam}
\title{Generates an offensive shot chart for a given team}
\usage{
OffShotSeasonGraphTeam(Seasondata, team, quant = 0.4, type = "PPS")
}
\arguments{
\item{Seasondata}{a data frame with the details of the season}

\item{team}{the name of the team that you want to make a graph of}

\item{quant}{the quantile of shots to be graphed, defaults to 0.4}

\item{type}{either "PPS" for points per shot or "PCT" for percentage}
}
\value{
a shot chart graph
}
\description{
creates an offensive Shot Chart for the desired team on a given season
}
\examples{
data("season2017")
#Examples with several teams
OffShotSeasonGraphTeam(season2017, team = "GSW")
OffShotSeasonGraphTeam(season2017, team = "Hou")
#Examples with shooting percentage instead of Points per Shot
OffShotSeasonGraphTeam(season2017, team = "ORL", type = "PCT")
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
