% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneill_leibovici_entropy.R
\name{leibovici}
\alias{leibovici}
\alias{`oneill`}
\title{O'Neill's and Leibovici's entropy.}
\usage{
leibovici(data, adj.mat, missing.cat = NULL, ordered = TRUE)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{adj.mat}{An adjacency matrix, upper- or lower-triangular.
Provided by user or generated by \code{\link[=adj_mat]{adj_mat()}}.}

\item{missing.cat}{Optional, a vector with the names of all categories that are
absent in \code{data}.}

\item{ordered}{Logical, \code{T} if the entropy is computed using ordered couples
(see \code{\link[=couple_count]{couple_count()}}), \code{F} if it is computed using pairs (see \code{\link[=pair_count]{pair_count()}}).}
}
\value{
Leibovici's spatial entropy value (O'Neill's entropy when contiguity is considered)
as well as a summary table containing the couples (or pairs)
along with their absolute and relative frequencies.
}
\description{
This function computes Leibovici's entropy according to a chosen distance \eqn{d}
(with O'Neill's entropy as a special case)
following Leibovici (2009), see also Altieri et al (2017). References can be found at \code{SpatEntropy}.
}
\details{
This index is based on the transformed variable \eqn{Z} identifying couples of realizations
of the variable of interest. A distance of interest is fixed, which in the case of O'Neill's
entropy is the contiguity, i.e. sharing a border for lattice data; this corresponds to
creating an adjacency (contiguity) matrix as done by \code{\link[=adj_mat]{adj_mat()}}. Then, all couples
of realizations of the variable of interest identified by the adjacency matrix are counted
and their relative frequencies are used to compute the index with the traditional Shannon's
formula. Couples can be ordered or not (pairs), with ordered couples as the default option
being the authors' choice.
}
\examples{
##O'NEILL
dist.mat=euclid_dist(cbind(rep(1:5, each=5), rep(1:5,5)))
adj.mat=adj_mat(dist.mat, dd1=dist.mat[1,2]) #for the contiguity matrix
data=sample(1:3, 25, replace=TRUE)
oneill=leibovici(data, adj.mat)

##LEIBOVICI
dist.mat=euclid_dist(cbind(rep(1:5, each=5), rep(1:5,5)))
adj.mat=adj_mat(dist.mat, dd1=4) #for the contiguity matrix
data=sample(1:3, 25, replace=TRUE)
leib=leibovici(data, adj.mat)

}
