% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{events}
\alias{completed}
\alias{completed,.simList,character-method}
\alias{completed,.simList,missing-method}
\alias{completed<-}
\alias{completed<-,.simList-method}
\alias{current}
\alias{current,.simList,character-method}
\alias{current,.simList,missing-method}
\alias{current<-}
\alias{current<-,.simList-method}
\alias{events}
\alias{events,.simList,character-method}
\alias{events,.simList,missing-method}
\alias{events<-}
\alias{events<-,.simList-method}
\alias{simList-accessors-events}
\title{Simulation event lists}
\usage{
events(object, unit)

\S4method{events}{.simList,character}(object, unit)

\S4method{events}{.simList,missing}(object, unit)

events(object) <- value

\S4method{events}{.simList}(object) <- value

current(object, unit)

\S4method{current}{.simList,character}(object, unit)

\S4method{current}{.simList,missing}(object, unit)

current(object) <- value

\S4method{current}{.simList}(object) <- value

completed(object, unit)

\S4method{completed}{.simList,character}(object, unit)

\S4method{completed}{.simList,missing}(object, unit)

completed(object) <- value

\S4method{completed}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{unit}{Character. One of the time units used in \code{SpaDES}.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{events} and \code{completed} slots of a
\code{simList} object.
By default, the event lists are shown when the \code{simList} object is printed,
thus most users will not require direct use of these methods.
\tabular{ll}{
   \code{events} \tab Scheduled simulation events (the event queue).\cr
   \code{completed} \tab Completed simulation events.\cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\note{
Each event is represented by a \code{\link{data.table}} row consisting of:
       \tabular{ll}{
         \code{eventTime} \tab The time the event is to occur.\cr
         \code{moduleName} \tab The module from which the event is taken.\cr
         \code{eventType} \tab A character string for the programmer-defined event type.\cr
       }
}
\seealso{
\code{\link{SpaDES}}, specifically the section 1.2.6 on Simulation event queues.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{envir}},
  \code{\link{globals}}, \code{\link{inputs}},
  \code{\link{ls.simList}}, \code{\link{ls.str.simList}},
  \code{\link{modules}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}

