% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SELES.R
\docType{methods}
\name{initiateAgents}
\alias{initiateAgents}
\alias{initiateAgents,Raster,missing,Raster,ANY,missing-method}
\alias{initiateAgents,Raster,missing,missing,ANY,missing-method}
\alias{initiateAgents,Raster,missing,missing,ANY,numeric-method}
\alias{initiateAgents,Raster,numeric,Raster,ANY,missing-method}
\alias{initiateAgents,Raster,numeric,missing,ANY,missing-method}
\title{\code{SELES} - Initiate agents}
\usage{
initiateAgents(map, numAgents, probInit, asSpatialPoints = TRUE, indices)

\S4method{initiateAgents}{Raster,missing,missing,ANY,missing}(map, numAgents,
  probInit, asSpatialPoints)

\S4method{initiateAgents}{Raster,missing,Raster,ANY,missing}(map, probInit,
  asSpatialPoints)

\S4method{initiateAgents}{Raster,numeric,missing,ANY,missing}(map, numAgents,
  probInit, asSpatialPoints = TRUE, indices)

\S4method{initiateAgents}{Raster,numeric,Raster,ANY,missing}(map, numAgents,
  probInit, asSpatialPoints)

\S4method{initiateAgents}{Raster,missing,missing,ANY,numeric}(map, numAgents,
  probInit, asSpatialPoints = TRUE, indices)
}
\arguments{
\item{map}{RasterLayer with extent and resolution of desired return object}

\item{numAgents}{numeric resulting from a call to \code{\link{numAgents}}}

\item{probInit}{a Raster resulting from a \code{\link{probInit}} call}

\item{asSpatialPoints}{logical. Should returned object be \code{RasterLayer}
or \code{SpatialPointsDataFrame} (default)}

\item{indices}{numeric. Indices of where agents should start}
}
\value{
A SpatialPointsDataFrame, with each row representing an individual agent
}
\description{
Sets the the number of agents to initiate. THIS IS NOT FULLY IMPLEMENTED.

A \code{SELES}-like function to maintain conceptual backwards compatability
with that simulation tool. This is intended to ease transitions from
\href{http://www.gowlland.ca/}{SELES}.

You must know how to use SELES for these to be useful.
}
\examples{
library(dplyr)
library(raster)
map <- raster(xmn=0, xmx=10, ymn=0, ymx=10, val=0, res=1)
map <- gaussMap(map, scale=1, var = 4, speedup=1)
pr <- probInit(map, p=(map/maxValue(map))^2)
agents <- initiateAgents(map, 100, pr)
Plot(map, new=TRUE)
Plot(agents, addTo="map")

# If producing a Raster, then the number of points produced can't be more than
# the number of pixels:
agentsRas <- initiateAgents(map, 30, pr, asSpatialPoints=FALSE)
Plot(agentsRas)

# Check that the agents are more often at the higher probability areas based on pr
out <- data.frame(stats::na.omit(crosstab(agentsRas, map)), table(round(map[]))) \%>\%
   dplyr::mutate(selectionRatio = Freq/Freq.1) \%>\%
   dplyr::select(-Var1, -Var1.1) \%>\%
   dplyr::rename(Present = Freq, Avail = Freq.1, Type = Var2)

}
\author{
Eliot McIntire
}

