% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-dependencies-class.R
\docType{class}
\name{.moduleDeps-class}
\alias{.moduleDeps-class}
\alias{.moduleDeps}
\title{The \code{.moduleDeps} class}
\description{
Descriptor object for specifying SpaDES module dependencies.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the module as a character string.}

\item{\code{description}}{Description of the module as a character string.}

\item{\code{keywords}}{Character vector containing a module's keywords.}

\item{\code{authors}}{The author(s) of the module as a \code{\link{person}} object.}

\item{\code{childModules}}{A character vector of child module names.
Modules listed here will be loaded with this module.}

\item{\code{version}}{The module version as a \code{numeric_version}.
Semantic versioning is assumed \url{https://semver.org/}.}

\item{\code{spatialExtent}}{Specifies the module's spatial extent as an
\code{\link{Extent}} object. Default is \code{NA}.}

\item{\code{timeframe}}{Specifies the valid timeframe for which the module was
designed to simulate. Must be a \code{\link{POSIXt}}
object of length 2, specifying the start and end times
(e.g., \code{as.POSIXlt(c("1990-01-01 00:00:00", "2100-12-31 11:59:59"))}).
Can be specified as \code{NA} using \code{as.POSIXlt(c(NA, NA))}.}

\item{\code{timeunit}}{Describes the time (in seconds) corresponding to 1.0
simulation time units. Default is \code{NA}.}

\item{\code{citation}}{A list of citations for the module, each as character strings.
Alternatively, list of filenames of \code{.bib} or similar files.
Defaults to \code{NA_character_}.}

\item{\code{documentation}}{List of filenames referring to module documentation sources.}

\item{\code{reqdPkgs}}{Character vector of R package names to be loaded.
Defaults to \code{NA_character_}.}

\item{\code{parameters}}{A \code{data.frame} specifying the object dependencies
of the module, with columns \code{paramName},
\code{paramClass}, and \code{default}, whose values are
of type \code{character}, \code{character}, and
\code{ANY}, respectively. Default values may be
overridden by the user by passing a list of parameters
to \code{\link{simInit}}.}

\item{\code{inputObjects}}{A \code{data.frame} specifying the object dependencies of
the module, with columns \code{objectName},
\code{objectClass}, and \code{other}.
For objects that are used within the module as both an
input and an output, add the object to each of these
\code{data.frame}s.}

\item{\code{outputObjects}}{A \code{data.frame} specifying the objects output by the
module, following the format of \code{inputObjects}.}
}}

\seealso{
\code{.simDeps}, \code{\link{spadesClasses}}
}
\author{
Alex Chubaty
}
\keyword{internal}
