% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{shrinkTEGS}
\alias{shrinkTEGS}
\title{Default shrinkage estimation of covariance matrices}
\usage{
shrinkTEGS(s, s1, s2, param = list(probs = 0.05, type = "min"))
}
\arguments{
\item{s}{covariance matrix estimte in the pooled sample}

\item{s1}{sample covariance matrix estimate in class 1}

\item{s2}{sample covariance matrix estimate in class 2}

\item{param}{list of parameters: \itemize{\item{\code{lamda}: a vector of lambdas (to be supplied only if some custom lambdas are to be used)} \item{\code{type}: minimum (\code{min}), maximum (\code{max}) or optimal (\code{opt})} \item {\code{probs}: the numeric value of probability with value in [0,1]}}}
}
\value{
The function returns a list of shrink covariance matrices.
}
\description{
The function adds a small quantity to the diagonals of covariance matrix estimates to regularize them.
}
\details{
To determine the quantity to add to the diagonals of covariance matrices, the function:
\itemize{
 \item{ finds the distributions of the sample variances of the p variables in the two classes and in the pooled sample}
 \item{ computes the \code{probs} percentile of each of these distributions }
 \item{ use the minimum, maximum or optimal (one for each matrix) (\code{type})}
}
}
\note{
It should be stressed that the default parameters for TEGS shrink estimator allow to compare the log likelihood criterion among distributions if the \code{\link[SourceSet]{testMeanVariance}} is performed.
}
\examples{


if(require(mvtnorm)){

  ## Generate two random samples of size 50 from two multivariate normal distributions
  # sample size
  n<-50
  # true parameters of class 1 and class 2
  param.class1<-simulation$condition1
  param.class2<-simulation$condition2$`5`$`2`
  # simulated dataset
  data.class1<-rmvnorm(n = n,mean =param.class1$mu ,sigma =param.class1$S)
  data.class2<-rmvnorm(n = n,mean =param.class2$mu ,sigma=param.class2$S)
  data<-rbind(data.class1,data.class2)
  classes<-c(rep(1,nrow(data.class1)),rep(2,nrow(data.class2)))

  ## estimated parameters: maximum likelihood estimate
  s<-cov(data)
  s1<-cov(data.class1)
  s2<-cov(data.class2)

  ## default parameters:
  # use the minimum of median variances distributions of the three supplied covariance matrices
  def.shrink<-shrinkTEGS(s,s1,s2)
  def.shrink$lambda

  ## use customize lamdas
  def.shrink<-shrinkTEGS(s,s1,s2,param = list(lambda=c(0.1,0.2,0.3)))
  def.shrink$lambda

  # use for each covariance matrix the 0.4 percentile of its variances distributions
  def.shrink<-shrinkTEGS(s,s1,s2,param = list(type="opt",probs=0.4))
  def.shrink$lambda
}

}
\references{
Huang, Y.-T. and Lin, X. (2013). Gene set analysis using variance component tests. BMC Bioinformatics, 14(1), 210.
}
\seealso{
\code{\link[SourceSet]{testMeanVariance}}, \code{\link[SourceSet]{parameters}}
}
