% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subpop.R
\name{Subpopplot}
\alias{Subpopplot}
\title{Plot 2-dimensional projections of variables in interest.}
\usage{
Subpopplot(varx, vary, output, xlim = NULL, ylim = NULL, main = NULL,
  sub = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{varx}{Variable to be plotted on the x-axis.}

\item{vary}{Variable to be plotted on the y-axis. If a variable in interest is of type factor, then user
must put it on the y-axis.}

\item{output}{Output of \code{Subpop} command.}

\item{xlim}{x-axis limits. Default is \code{range(data[, varx])}}

\item{ylim}{y-axis limits. Default is \code{NULL}.}

\item{main}{Main title of the plot. Default is \code{NULL}.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is \code{NULL}.}

\item{ylab}{y-axis label. Default is \code{NULL}.}
}
\description{
\code{Subpopplot} takes output from \code{\link{Subpop}} command as inputs and plots 2-dimensional projection plots of two specified variables.
A factor variable has to be put on the y-axis, otherwise the code breaks. The users need to specify the two variables for the projection
with \code{varx} and \code{vary}, and \code{output} should be specified as the output of \code{\link{Subpop}}.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc
result <- Subpop(fm = fm, data = mortgage, var.T = "black", method = "logit")
Subpopplot(varx = mortgage$p_irat, vary = mortgage$ccred, output = result)

}
